from PIL import Image
import random

def get_mat(file_in):
    """
    file_in: str
    Return: list[list[int,int,int]]
    ----
    Renvoie la matrice RGB correspondant à l'image contenue dans file_in.
    """
    img = Image.open(file_in)
    L, H = img.size
    mat = [[img.getpixel((j,i)) for j in range(L)] for i in range(H)]
    return mat

def save(mat, file_out):
    """
    mat: list[list[int,int,int]]
    file_out: str
    Return: NoneType
    ----
    Enregistre dans file_out l'image qui correspond à la matrice RGB mat
    Hypothèse: l'image n'est pas vide.
    """
    if type(mat) != list:
        raise ValueError("'mat' doit être une liste")
    if len(mat) == 0:
        raise ValueError("'mat' ne doit pas être une liste vide")
    if [L for L in mat if type(L) != list] != []:
        raise ValueError("'mat' doit être une liste de listes")
    if [e for L in mat for e in L if type(e) != tuple] != []:
        raise ValueError("'mat' doit contenir des tuples")
    if [e for L in mat for e in L if len(e) != 3] != []:
        raise ValueError("Les tuples de 'mat' doivent être des triplets")
    if [c for L in mat for e in L for c in e if type(c) != int] != []:
        raise ValueError("Les triplets de 'mat' doivent contenir des entiers")
    H = len(mat)
    L = len(mat[0])
    for i in range(1, len(mat)):
        if len(mat[i]) != L:
            raise ValueError("Toutes les lignes de mat doivent être de la même taille")
    img = Image.new("RGB", (L, H))
    for i in range(H):
        for j in range(L):
            r,g,b = mat[i][j]
            img.putpixel((j,i), (r,g,b))
    img.save(file_out)

def copie(file_in, file_out):
    """
    file_in, file_out: str
    Return: NoneType
    ----
    Copie l'image contenue dans le fichier file_in vers le fichier file_out.
    """
    print("Copie de", file_in)
    mat = get_mat(file_in)
    save(mat, file_out)

mat = [
    [(255,0,0),(0,255,0),(0,0,255)],
    [(255,255,0),(0,0,0),(255,255,255)]
]
save(mat,"TP09_images/exemple.png")
copie("TP09_images/bretagne.jpg",
      "TP09_images/bretagne_copie.png")
copie("TP09_images/pinguoin.png",
      "TP09_images/pinguoin_copie.jpg")
copie("TP09_images/papillon.png",
      "TP09_images/papillon_copie.png")